
/* texteditor.c - simple example of TextEditor gadget to show problems
 *
 * Puts up a TextEditor with bold, italic and underlined styles.
 *
 */

 /*
 Problem:
 - 
*/

#define ALL_REACTION_CLASSES
#include <reaction/reaction_macros.h>

#include <exec/exec.h>
#include <intuition/intuition.h>
#include <dos/dos.h>
#include <images/label.h>
#include <classes/window.h>
#include <gadgets/layout.h>
#include <gadgets/texteditor.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/intuition.h>
#include <proto/window.h>
#include <proto/layout.h>
#include <proto/texteditor.h>

struct Library *LayoutBase,*TextFieldBase,*ClickTabBase,*WindowBase;

Object *win;
Object *TxtEd;

struct MsgPort *AppPort;
struct HintInfo p_hintinfo; 

Object * make_window(void)
{
    return NewObject(NULL, "window.class",
        WA_ScreenTitle,        "ReAction Example",
        WA_Title,              "TextEditor Example",
        WA_DragBar,            TRUE,
        WA_CloseGadget,        TRUE,
        WA_SizeGadget,         TRUE,
        WA_DepthGadget,        TRUE,
        WA_Activate,           TRUE,
        WA_InnerWidth,         260,
        WA_InnerHeight,        100,
        WINDOW_IconifyGadget,  TRUE,
        WINDOW_IconTitle,      "Iconified",
        WINDOW_GadgetHelp,     TRUE,
        WINDOW_HintInfo,       &p_hintinfo, 
        WINDOW_AppPort,        AppPort,
        WINDOW_Position,       WPOS_CENTERSCREEN,
        WINDOW_Layout,         LayoutObject,
                                 LAYOUT_AddChild, TxtEd = TextEditorObject,
                                   GA_ReadOnly, TRUE,
                                   GA_TEXTEDITOR_BevelStyle, BVS_NONE,
                                   GA_TEXTEDITOR_Contents, "\33bbold\33iitalic\33uunderlined\33nnormal",
                                   GA_TEXTEDITOR_ImportHook, GV_TEXTEDITOR_ImportHook_Plain,
                                 TAG_END),  

                               TAG_END),  
  TAG_DONE);
}


int main()
{
struct Window *window;

WindowBase = OpenLibrary("window.class",0);/* librairie fentre */
LayoutBase = OpenLibrary("gadgets/layout.gadget",0);/* librairie layout (disposition fentre) */
ClickTabBase = OpenLibrary("gadgets/clicktab.gadget",0L);
TextFieldBase = OpenLibrary("gadgets/texteditor.gadget",0);/* TextEditor */
AppPort=CreateMsgPort();

if (LayoutBase && ClickTabBase && TextFieldBase && AppPort)
  {
  win = make_window();
  if (window = (struct Window*)RA_OpenWindow(win))
    {
    BOOL done = FALSE;
    
    DoGadgetMethod((struct Gadget *)TxtEd, window, NULL,
                           GM_TEXTEDITOR_InsertText, NULL, (ULONG) "\n\33bbold\33iitalic\33uunderlined\33nnormal",
                           GV_TEXTEDITOR_InsertText_Bottom);

    ULONG sigmask = 0;
    GetAttr(WINDOW_SigMask, win, &sigmask);

    while (!done)
      {
      ULONG siggot = Wait(sigmask | SIGBREAKF_CTRL_C);
      if (siggot & SIGBREAKF_CTRL_C)
        {
        done = TRUE;
        }

      ULONG result = 0;
      UWORD code   = 0;

      while ((result = RA_HandleInput(win, &code)) != WMHI_LASTMSG)
        {
        switch(result & WMHI_CLASSMASK)
          {
          case WMHI_CLOSEWINDOW:
            done = TRUE;
            break;

          case WMHI_GADGETUP:
          /*  switch (result & WMHI_GADGETMASK)
              {
              case OBJ_BTN0:
                done = TRUE;
                break;

              case OBJ_QUIT:
                done = TRUE;
                break;
              }*/
            break;

          case WMHI_ICONIFY:
            if (RA_Iconify(win))
              {
              window = NULL;
              }
            break;

          case WMHI_UNICONIFY:
            window = (struct Window*)RA_OpenWindow(win);
            break;

          case WMHI_RAWKEY:
            break;
          }
        }
      }

    DisposeObject(win);
    }

  if (WindowBase)
    CloseLibrary(WindowBase);
  if (LayoutBase)
    CloseLibrary(LayoutBase);
  if (ClickTabBase)
    CloseLibrary(ClickTabBase);
  if (TextFieldBase)
    CloseLibrary(TextFieldBase);
  if (AppPort)
    DeletePort(AppPort);    
  }
}
