/* Execute me to compile
gcc -o virtual virtual.c -lauto
quit
;*/

/* virtual.c - simple example of virtual to show problems
 *
 * Puts up a (vertical) virtual gadget with a few buttons in it.
 *
 */

 /*
 Problems:
 - The scroll wheel only works in the gaps between the buttons: it seems that the event detected above the buttons
 is not "moved up" to the upper level.
 - Clicking on the first or last button ([Quit]) does not trigger an event, except if you click on the second or
 third tab then again on first one.
 - The tooltip is not displayed.
*/

#define ALL_REACTION_CLASSES
#include <reaction/reaction_macros.h>

#include <exec/exec.h>
#include <intuition/intuition.h>
#include <dos/dos.h>
#include <images/label.h>
#include <classes/window.h>
#include <gadgets/layout.h>
#include <gadgets/virtual.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/intuition.h>
#include <proto/window.h>
#include <proto/layout.h>
#include <proto/virtual.h>

struct Library *LayoutBase,*VirtualBase,*ClickTabBase;

Object *win;

struct MsgPort *AppPort;

Object * make_window(void)
{
    return NewObject(NULL, "window.class",
        WA_ScreenTitle,        "ReAction Example",
        WA_Title,              "Virtual Example",
        WA_DragBar,            TRUE,
        WA_CloseGadget,        TRUE,
        WA_SizeGadget,         TRUE,
        WA_DepthGadget,        TRUE,
        WA_Activate,           TRUE,
        WA_InnerWidth,         260,
        WA_InnerHeight,        100,
        WINDOW_IconifyGadget,  TRUE,
        WINDOW_IconTitle,      "Iconified",
        WINDOW_GadgetHelp,     TRUE,
        WINDOW_AppPort,        AppPort,
        WINDOW_Position,       WPOS_CENTERSCREEN,
        WINDOW_Layout,         VirtualObject,
                                  VIRTUALA_Contents, VLayoutObject,
                                     LAYOUT_AddChild, ButtonObject,
					                   GA_Text, "Button",
					                 TAG_DONE),
                                  TAG_END),
                                TAG_END),  
    TAG_DONE);
}


int main()
{
struct Window *window;

LayoutBase = OpenLibrary("gadgets/layout.gadget",0);/* librairie layout (disposition fentre) */
ClickTabBase = OpenLibrary("gadgets/clicktab.gadget",0L);
VirtualBase = OpenLibrary("gadgets/virtual.gadget",0);/* Champ virtual */
AppPort=CreateMsgPort();

if (LayoutBase && ClickTabBase && VirtualBase && AppPort)
  {
  win = make_window();
  if (window = (struct Window*)RA_OpenWindow(win))
    {
    BOOL done = FALSE;

    ULONG sigmask = 0;
    GetAttr(WINDOW_SigMask, win, &sigmask);

    while (!done)
      {
      ULONG siggot = Wait(sigmask | SIGBREAKF_CTRL_C);
      if (siggot & SIGBREAKF_CTRL_C)
        {
        done = TRUE;
        }

      ULONG result = 0;
      UWORD code   = 0;

      while ((result = RA_HandleInput(win, &code)) != WMHI_LASTMSG)
        {
        switch(result & WMHI_CLASSMASK)
          {
          case WMHI_CLOSEWINDOW:
            done = TRUE;
            break;

          case WMHI_GADGETUP:
            done = TRUE;    
            break;

          case WMHI_ICONIFY:
            if (RA_Iconify(win))
              {
              window = NULL;
              }
            break;

          case WMHI_UNICONIFY:
            window = (struct Window*)RA_OpenWindow(win);
            break;

          case WMHI_RAWKEY:
            break;
          }
        }
      }

    DisposeObject(win);
    }

  if (LayoutBase)
    CloseLibrary(LayoutBase);
  if (ClickTabBase)
    CloseLibrary(ClickTabBase);
  if (VirtualBase)
    CloseLibrary(VirtualBase);
  if (AppPort)
    DeletePort(AppPort);    
  }
}
